/* test the granularity of the gettimeofday() system call, simultaneously
 * getting an estimate of system call overhead.
 */

#define REAL 0

#include <unistd.h>
#include <sched.h>
#include <sys/mman.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define N_ITERATIONS 1000000

struct timeval	timeval_store [N_ITERATIONS] ;

unsigned long gettodms() ;

main() {

	int i; 
	long starttime, endtime ;
#if REAL
	init_realtime() ;
#endif
	printf ("\nSTART\n") ;
	usleep (10000) ;
	starttime = gettodms() ;
	for (i = 0 ; i < N_ITERATIONS; i++) {
        	gettimeofday (&(timeval_store[i]), NULL) ;
	}
	endtime = gettodms () ;
	printf ("\nEND\n") ;

	printf("%d calls to gettimeofday() took %ld ms\n", N_ITERATIONS,
		endtime - starttime) ;

	/* checktime() calculates and prints the mean and the maximum 
	 * time between the getttimeofday() calls...
	 */
	checktime() ;
		
}


checktime()
{
	int i; 
	float total = 0.0, squaretotal = 0.0 ;
	float mean, std ;
	int cnt ;

	long 	max = 0, 
		gt5cnt = 0,
		gt10cnt = 0,
		diff, lastsec, lastusec, currsec, currusec;

	lastsec = timeval_store[0].tv_sec ;
	lastusec = timeval_store[0].tv_usec ;
	for (i = 1 ; i < N_ITERATIONS; i++)  {
		currsec = timeval_store[i].tv_sec ;
		currusec = timeval_store[i].tv_usec ;
		if (currsec == lastsec)
			diff = currusec - lastusec ;
		else
			diff = (1000000 + currusec) - lastusec ; 
		total = total + diff ;
		squaretotal = squaretotal + (float)diff * (float)diff ;
		if (diff > max)
			max = diff ;
		if (diff > 5)
			gt5cnt++ ;
		if (diff > 10)
			gt10cnt++ ;
		lastsec = currsec ;
		lastusec = currusec ;
	}
	cnt = N_ITERATIONS - 1 ;
	mean = total/cnt ;
	std = squaretotal - (total * total)/cnt ; 
	std = std/cnt ;
	std = sqrt (std) ; 
	printf("Time between calls:\n"
		"max =\t%ld us\nmean =\t%.2f us\nstd =\t%.2f us\ncnt > 10 us =\t%ld\n",
		max, mean, std, gt10cnt ) ;
}
		



init_realtime()
{
        struct sched_param sp ;
        sp.sched_priority = 40 ;
        if (mlockall(MCL_CURRENT | MCL_FUTURE) < 0) {
                perror ("mlockall") ;
        };
        if (sched_setscheduler (0, SCHED_FIFO,  &sp) < 0) {
                perror ("sched_setscheduler") ;
        };
}


unsigned long tv_to_ms(tvp)
struct timeval *tvp ;
{
        return (tvp->tv_sec * 1000  + tvp->tv_usec/1000) ;
}

unsigned long gettodms()
{       struct timeval tv ;
        gettimeofday (&tv, NULL) ;
        return (tv_to_ms (&tv)) ;
}






