/************************************************************************
 * ftap: a Linux-based, MIDI-based program for running tapping and music
 * experiments.
 * 
 * Copyright (C) 1999, 2000, 2016 Steven A. Finney
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Steve Finney can be reached by email at sfinney@sfinney.com.
 */

/* stuff to implement call of a C function on a trigger. For now, 
 * used only to send a programmed sound, but could have many
 * uses (e.g., visual displays).
 */

#include <linux/types.h>
#include <errno.h>

#include "config.h"
#include "linux.h"
#include "ftaplimits.h"
#include "tapmidi.h"
#include "params.h"

/* predeclare the functions */
/* NEED SOME SORT OF ERROR CHECKING ON THE ARRAY INDEX */

int send_pulse() ;

/* for now, indexed by the function number; really should be a table
 * search (and a user-extensible table). NO ERROR CHECKING. FIXME.
 */
struct func_desc 
func_table[] = 
{ 
	{0, 0},
	{1, send_pulse},
	{0, 0}
} ;


/* use the pulse parameters to set up the desired note on and note off.
 * Should probably be a new type: P. (for now, use J). FIXME.
 * 
 * NO ERROR CHECKS ON REASONABLE PULSE PARAMETERS
 */

int send_pulse() {
	long curtime ;
	curtime = gettodms() ;
	sched_midi_note(pulse_chan_param, pulse_note_param,
               pulse_vel_param, NOTEDOWN, TE_NOTE | TE_PULSE, curtime) ;
	sched_midi_note(pulse_chan_param, pulse_note_param, 
		0, NOTEUP, TE_NOTE | TE_PULSE, curtime + pulse_len_param) ;

}


