/************************************************************************
 * ftap: a Linux-based, MIDI-based program for running tapping and music
 * experiments.
 * 
 * Copyright (C) 1999, 2000 Steven A. Finney
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Steve Finney can be reached by email at sfinney@sfinney.com.
 */

/* Various hard wired limits, they can probably be freely changed 
 * within reason. 
 */

/* 4/4/2016, sf, increase most general storage limits by a factor of 10 or 
 * more; memory is not a scarce resource on modern machines and EEG people
 * may want lots of triggers. Not thoroughly tested, but should work.
 *
 * A few other limits were also increased a bit.
 */

/* MAXNOTES:   maximum number of midi events in a run (so: important). This is
 * the static, preallocated limit in memory (separately) for keystroke storage
 * and for feedback event/metronome storage; the program will stop recording
 * data when this limit is exceeded (and print out loud error messages).
 *
 * NOTE: will this be too _large_ for some machines?
 */


#define MAXNOTES 100000

/* maximum total number of trigger events, allocated to subtypes as the
 * user chooses.
 */

#define MAX_TRIG_EVENTS 5000

/* Maximum number of delays in random delay list */
#define MAXRDELAYS  10

/* Maximum length of metronome pattern */
#define MAXPATTERN	40

#ifdef PPT

/* Maximum number of IOI's in proportional delay calculation */
#define MAXIOI		20

#endif

/* Maximum number of active/transient events (primarily in output scheduling
 * queue). This number includes all prescheduled events (which may be many 
 * with the inclusion of click files). When these modules are used by
 * the playftap program, this number can be reached; perhaps the data 
 * allocation should be done in a separate module.
 */

#define MAX_TE_EVENTS 20000

