#!/usr/bin/env python

# Program to parse the output file from an FTAP looptest run
# and print a behavioral summary to stdout

import string, sys
import numpy     # for mean and sd: sudo apt-get install python-numpy
if len (sys.argv) != 2:
	print "Usage: loopcheck <file>"
	sys.exit()



lines = open (sys.argv[1], "r").readlines()
lines = map (string.split, lines)

#collect the keydown event times
keylist = []

for line in lines:
	if line[0] == "#" or not line or line[0].isspace():
		continue
	if line[7] == "K":
		keylist.append(int(line[0]))

# process into time between keystrokes (ioi)
ioilist = []
timelist = []
for i in range(1, len(keylist)):
	ioilist.append(keylist[i] - keylist[i - 1]);
        timelist.append(keylist[i]);

if ioilist:
        highvals = {}
	mean2 = float(sum(ioilist))/len(ioilist)
        mean = numpy.mean (ioilist)
        std = numpy.std(ioilist)
	for i in range(1, len(ioilist)):
		ioi = ioilist[i]
		if ioi > 1:
			if highvals.has_key(ioi):
				highvals[ioi].append(timelist[i])
			else:
				highvals[ioi] = [ timelist[i] ]
	if highvals:
		maxvals = highvals.keys()
		nummax = len(maxvals)
        	max = max(maxvals)
		maxvals.sort()
	else:
		max = 1
	print "%d keystrokes, mean IOI = %.2f ms, std %.2f, max = %d"  %  \
		(len(ioilist), mean, std, max)


#	1st print data for the highest delay value
	
	MAXPRINT = 10
	delaysprinted = 0
	delays = highvals[max]
	n = len(delays)
	print "%d ms delay at:" % max,
	for i in range(0,n):
		print delays[i], 
		delaysprinted = delaysprinted + 1;
		if (delaysprinted == MAXPRINT):
			break
	print

# 	if we haven't printed 10 yet, go to the next highest delay
	if (len(maxvals) > 1) and (delaysprinted < MAXPRINT):
		max = maxvals[len(maxvals) - 2]
		delays = highvals[max]
		n = len(delays)
		print "%d ms delay at:" % max,
		for i in range(0,n):
			print delays[i], 
			delaysprinted = delaysprinted + 1;
			if (delaysprinted == MAXPRINT):
				break
	print
	
	
else:
	print "No Data!"

