#include <linux/rtc.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

main()
{	
	int i ;
#define INTR_HZ 1024
#define MAX_INTR (INTR_HZ * 10 )

	struct timeval starttime, endtime ;
	printf ("executing %d interrupts at %.1f ms (total == %.1f)\n", 
		MAX_INTR,
		1000.0/INTR_HZ, MAX_INTR * 1000.0/INTR_HZ) ;
	gettimeofday (&starttime, NULL) ;

	for (i = 0 ; i < MAX_INTR ; i++) {
		rtc_nap1() ;
	}
	gettimeofday (&endtime, NULL) ;
        printf("starttime: seconds %ld milsec %ld micsec %ld\n",
                starttime.tv_sec, starttime.tv_usec/1000,
                starttime.tv_usec);
        printf("endtime: seconds %ld milsec %ld micsec %ld\n",
                endtime.tv_sec, endtime.tv_usec/1000,
                endtime.tv_usec);
	printf ("ms diff = %ld\n", (endtime.tv_sec - starttime.tv_sec)
		* 1000 + (endtime.tv_usec - starttime.tv_usec)/ 1000);
}

		




/* routine to sleep for .976 (1000/1024) milliseconds. Must be run by root,
 * and can only be run by one user at a time. Uses periodic interrrupt (PIE)
 * mode of /dev/rtc.
 * 
 * timedata & 0xFFF0 >> 8 should contain number of missed interrupts if it
 * needs to be tracked here.
 */

#define INTR_HZ 1024

rtc_nap1()
{
	static int rtfd, firsttime = 1 ;

	unsigned long timedata ;
	int retval ;
	if (firsttime) {
		if ((rtfd = open ("/dev/rtc", O_RDONLY)) < 0) {
			perror ("/dev/rtc: open") ;
			exit (-1) ;
		}
		if ((retval = ioctl (rtfd, RTC_IRQP_SET, INTR_HZ )) < 0) {
			perror ("/dev/rtc: IRQP_SET") ;
			exit (-1) ;
		}
		if ((retval = ioctl (rtfd, RTC_PIE_ON, 0)) < 0) {
			perror ("/dev/rtc: PIE_ON") ;
			exit (-1) ;
		}
		firsttime = 0 ;
	}
	if ((retval = read (rtfd, &timedata, sizeof (unsigned long))) < 0) {
		perror ("/dev/rtc: read") ;
		exit (-1) ;
	}
}

		
