#!/usr/bin/env python

# Q & D script to make a clean distribution hierarchy (without
# all the crap I leave lying around). This also makes sure that
# all the generated files match the sources.

import os

VERSION="2.1.07a"
distdir = "dist" + VERSION

# currently, top level directories must be first
directories = [
"bin",
"doc",
"params",
"params/benchmark",
"params/demo",
"params/demo/genclick",
"params/demo/pitchseq",
"params/sample_experiments",
"params/sample_experiments/genclick",
"src",
"utils",
"utils/gettod_test",
"utils/midicopy",
"utils/playftap",
"utils/playftap/test",
"utils/python",
".dev",
".dev/params",
".dev/params/test",
".dev/utils",
".dev/utils/timetests",
]

files =  [
"GNU_PUBLIC_LICENSE",
"RELEASE_NOTES",

"doc/ftap.bib",
"doc/ref.tex",
"doc/user.tex",
"doc/makeref",
"doc/makeuser",
"doc/scip_summary.text",

"src/config.h",
"src/ftap.c",
"src/ftaplimits.h",
"src/func_modules.c",
"src/linux.h",
"src/linux_midi.c",
"src/linux_utils.c",
"src/lists.c",
"src/map.c",
"src/metron.c",
"src/output.c",
"src/params.c",
"src/params.h",
"src/tapmidi.h",
"src/triggers.c",
"src/makeftap.sh",
"src/README",
"src/GNU_PUBLIC_LICENSE",

"params/benchmark/loopcheck.py",
"params/benchmark/looptest",
"params/benchmark/looptest_60s",
"params/benchmark/README",
"params/benchmark/run_loopcheck.sh",
"params/benchmark/run_looptest.sh",

"params/demo/bachpitch",
"params/demo/cont",
"params/demo/genclick/click_250.randb",
"params/demo/keythru",
"params/demo/lag1pitch",
"params/demo/metronpat1",
"params/demo/metronpat2",
"params/demo/metronpat3",
"params/demo/metronpat4",
"params/demo/metronpat5",
"params/demo/mettrigger",
"params/demo/perturb",
"params/demo/pitchseq/bach",
"params/demo/pitchseq/scale",
"params/demo/randdelay",
"params/demo/README",
"params/demo/revpitch",
"params/demo/scalepitch",
"params/demo/smeseno",
"params/demo/splitchan",
"params/demo/trigger",
"params/demo/twochan",

"params/sample_experiments/aschersleben_97",
"params/sample_experiments/finn_99_275",
"params/sample_experiments/finn_99_drop",
"params/sample_experiments/finn_99_fixed",
"params/sample_experiments/finn_99_rand",
"params/sample_experiments/README",
"params/sample_experiments/repp_00",
"params/sample_experiments/wing_77",
"params/sample_experiments/genclick/click_250.42",



"utils/makeall",
"utils/README",
"utils/gettod_test/makegettod",
"utils/gettod_test/README",
"utils/gettod_test/runtests.sh",
"utils/gettod_test/arith.c",
"utils/gettod_test/gt_sp_test.c",
"utils/gettod_test/gt_testn.c",
"utils/gettod_test/gt_testr.c",
"utils/midicopy/makemc",
"utils/midicopy/midicopy.c",
"utils/midicopy/README",
"utils/playftap/ftaplimits.h",
"utils/playftap/tapmidi.h",
"utils/playftap/playftap.c",
"utils/playftap/makepf",
"utils/playftap/README",
"utils/playftap/test/feedonly.abs",
"utils/playftap/test/mixed.abs",
"utils/python/run.py",
]

# stuff that will go in the physical distribution but that the
# user doesn't need to be distracted by
devfiles =  [
"makedist.py",
"utils/timetests/quicknap.c",
"utils/timetests/rtc.c",
"params/test/limitstest",
"params/test/limitstest_10ms",
"params/test/README",
]
   
os.system("rm -rf " + distdir)
os.mkdir(distdir)

for i in directories:
	os.mkdir(distdir + '/' + i)

for i in files:
	os.system("cp %s %s" % (i, distdir + '/' + i) )

for i in devfiles:
	os.system("cp %s %s" % (i, distdir + '/' + ".dev/" + i) )

# do the doc and source builds in the dist directory
os.chdir(distdir)
os.chdir("src") 
os.system("bash makeftap.sh")
os.chdir("../doc")
os.system("bash makeref")
os.system("bash makeuser")
os.system("rm *.bbl *.blg *.log *.aux *.toc");
os.chdir("../utils")
os.system("bash makeall")

os.chdir("../..")
os.system("rm *.tar *.gz")
tarfile = "ftap" + VERSION + ".tar"
os.system("tar cvf " + tarfile + " " + distdir)
os.system("gzip -f " + tarfile)


