#include <linux/mc146818rtc.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>

#define MAX_INTR 81920
#define INTR_HZ 8192
int intr_cnt = 0 ;

/* try running /dev/rtc at about 125 usec */

struct timeval starttime, endtime ;

unsigned long timedata ;

main()
{	int rtfd, retval, i ;
	if ((rtfd = open ("/dev/rtc", O_RDONLY)) < 0) {
		perror ("open /dev/rtc") ;
		exit (-1) ;
	}
	if ((retval = ioctl (rtfd, RTC_IRQP_SET, INTR_HZ )) < 0) {
		perror ("IRQP_SET") ;
		exit (-1) ;
	}
	printf ("executing %d interrupts at %.1f ms (total == %.1f)\n", 
		MAX_INTR,
		1000.0/INTR_HZ, MAX_INTR * 1000.0/INTR_HZ) ;
	gettimeofday (&starttime, NULL) ;

	if ((retval = ioctl (rtfd, RTC_PIE_ON, 0)) < 0) {
		perror ("PIE_ON") ;
		exit (-1) ;
	}
	for (i = 0 ; i < MAX_INTR ; i++) {
		if ((retval = read (rtfd, &timedata, sizeof (unsigned long))) < 0) {
			perror ("read") ;
			exit (-1) ;
		}
	}
	printf ("Sample interrupt type:  %x ", timedata & 0xFF) ;
	printf ("Sample interrupt cnt:  %x ", (timedata >> 8) & 0xFFFFFF) ;
	printf ("\n") ;
	gettimeofday (&endtime, NULL) ;
        printf("starttime: seconds %ld milsec %ld micsec %ld\n",
                starttime.tv_sec, starttime.tv_usec/1000,
                starttime.tv_usec);
        printf("endtime: seconds %ld milsec %ld micsec %ld\n",
                endtime.tv_sec, endtime.tv_usec/1000,
                endtime.tv_usec);
	printf ("ms diff = %d\n", (endtime.tv_sec - starttime.tv_sec)
		* 1000 + (endtime.tv_usec - starttime.tv_usec)/ 1000);
}

		
		
