/************************************************************************
 * rawmidiloop: a Linux-based, MIDI-based program for testing speed of
 * a MIDI interface with a loop cable.
 * 
 * Copyright (C) 1999, 2000 Steven A. Finney
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Steve Finney can be reached by email at finney.17@osu.edu.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/time.h>

/* read from MIDI port and copy back out again, just single bytes. */

/* TO DO: write 3 byte messages, check byte values*/

#define N_ITERATIONS 5


unsigned long gettodms() ;


extern int errno ;

#define DEVICE "/dev/midi"

int mfd ;

char c = 'c' ;

main()
{
	int i, j,  cnt, retval ;

	mfd = open (DEVICE, O_RDWR) ;
	if (mfd < 0) {
		printf ("errno = %d, device %s\n", errno, DEVICE) ;
		perror ("midi device open") ;
		exit (-1) ;
	}
	else
		printf("%s opened successfully, fd %d\n\n", DEVICE, mfd); 

	/* priming byte */
	printf("writing priming byte\n") ;
	retval = write (mfd, &c, 1) ;
	if (retval <= 0) {
		printf("write error, retval %d, errno %d\n",
			retval, errno) ;
		exit (-1) ;
	}
	printf("starting loop\n") ;
        for (i = 0; i < N_ITERATIONS ; i++){
		printf("about to read()\n") ;
		retval = read (mfd, &c, 1) ;
		if (retval <= 0) {
			printf("read error, retval %d, errno %d\n",
				retval, errno) ;
			exit (-1) ;
		}
		printf ("read: 0x%x, %u ms\n", c & 0xFF, gettodms()) ;
		retval = write (mfd, &c, 1) ;
		if (retval <= 0) {
			printf("write error, retval %d, errno %d\n",
				retval, errno) ;
			exit (-1) ;
		}
	
	}

}

unsigned long tv_to_ms(tvp)
struct timeval *tvp ;
{
	return (tvp->tv_sec * 1000  + tvp->tv_usec/1000) ;
}

unsigned long 
gettodms()
{	struct timeval tv ;
	gettimeofday (&tv, NULL) ;
	return (tv_to_ms (&tv)) ;
}
