#!/usr/bin/env python

# Sample driver file for an FTAP experiment

import os, whrandom, sys, string

print "\nEnter parameter file prefix: ",
line = sys.stdin.readline()
prefix = (string.split (line) ) [0]

print "\nEnter subject ID: ",
line = sys.stdin.readline()
subject_id = (string.split (line) ) [0]

print "\nEnter block number: ",
line = sys.stdin.readline()
block_id = (string.split (line) ) [0]

start_trial = 1

# List of all the conditions for this experiment (these are the
# parameter files suffixes).
suffixes = ["_s", "_100", "_150", "_200", "_250", "_300", "_350",
    "_400", "_450", "_500", "_550" ]

# source directory for parameter files
param_path = "/home/sf/texp10/params/"

trial_count =  3          # of trials in each condition
trial_break =  17         # give a break after 17 trials


# create a list in which each suffix/condition occurs 3 times
suffixes = trial_count * suffixes
trial_num = start_trial

# Create override parameters for FTAP invocation. Assumes that subject and 
# block will not change within a single run 
sub_param =   "SUB "   + `subject_id`
block_param = "BLOCK " + `block_id`


while suffixes:
        if trial_num == trial_break:
              print "\nFIRST BREAK: Hit <CR> to continue.." 
              line = sys.stdin.readline()    #  experimenter can type anything

   
	# randomly choose a condition to run...
        suffix = whrandom.choice (suffixes) 
        suffixes.remove (suffix)
     
	# construct the command line to execute...
        file = param_path + prefix + suffix 
        trial_param = "TRIAL " + `trial_num` 

        exec_line = "ftap " + file   + "  '" + sub_param +  " '"  + \
           "  '" + trial_param +  " '" +  "  '" + block_param +  " '"  
        print "\n\nHit <CR> to start trial %d, file %s" % (trial_num, file)
        line = sys.stdin.readline()           #  experimenter can type anything

        os.system (exec_line)
        trial_num = trial_num + 1
