/************************************************************************
 * ftap: a Linux-based, MIDI-based program for running tapping and music
 * experiments.
 * 
 * Copyright (C) 1999, 2000 Steven A. Finney
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Steve Finney can be reached by email at finney.17@osu.edu.
 */

/*
 * Although this program is provided "as is", I have taken some pains to
 * try to make it robust and general purpose. I will certainly try to
 * respond to bug reports, bug fixes, suggestions, and comments. Although
 * I don't know of any major bugs, there are certainly some rough spots,
 * and the (verbose) comments in the code (particularly in the headers)
 * are somewhat out of date (but they should be mostly correct). They'll
 * be cleaned up someday. This program has been compiled with gcc.
 */

/* hard wired limits, can be changed */

/* An important constant:   maximum number of midi events in a run. This is
 * the static, preallocated limit in memory (separately) for keystroke storage
 * and for feedback event/metronome storage; the program will stop recording
 * data when this limit is exceeded (and print out loud error messages).
 */

#define MAXNOTES 5000

/* maximum total number of trigger events, allocated to subtypes as the
 * user chooses.
 */

#define MAX_TRIG_EVENTS 60

/* Maximum number of delays in random delay list */
#define MAXRDELAYS  10

/* Maximum length of metronome pattern */
#define MAXPATTERN	20

/* Maximum number of active/transient events (primarily in output scheduling
 * queue). This number includes all prescheduled events (which may be many 
 * with the inclusion of click files). When these modules are used by
 * play programs, this number can be reached; perhaps the data allocation
 * should be done in a separate module.
 */

#define MAX_TE_EVENTS 15000

