/************************************************************************
 * midicopy: a simple  Linux-based, MIDI-based program that allows you
 * to play a keyboard through a tone generator, and that prints out the
 * input MIDI bytes.  Just reads in (and writes out) one MIDI byte at
 * a time. Useful for testing MIDI interface functionality for FTAP use.
 * 
 * Copyright (C) 1999, 2000 Steven A. Finney
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Steve Finney can be reached by email at finney.17@osu.edu.
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>



extern int errno ;


#define DEVICE "/dev/midi"

/* number of MIDI bytes per output line */
#define MAX_MIDI_MSG 16


main()
{
	char c;
	int retval, linecnt = 0 ;
	int mfd ;

	mfd = open (DEVICE, O_RDWR) ;
	if (mfd < 0) {
		perror ("MIDI device open error: ") ;
		printf ("errno = %d, device %s\n", errno, DEVICE) ;
		exit (-1) ;
	}
	else {
		printf("Reading and writing from  %s\n", DEVICE, mfd); 
		printf("Hit ctl-C or equivalent to exit\n") ;
	}
	setbuf (stdout, NULL) ;
        while (1) {
		retval = read (mfd, &c, 1) ;
		if (retval != 1) {
			printf("\nRead Error, read returned %d,"
			"  errno %d, exiting...\n", retval, errno) ;
			perror ("midi read") ;
		}
		printf ("0x%x ", c & 0xFF) ;
		if (++linecnt == MAX_MIDI_MSG) {
			linecnt = 0 ;
			printf ("\n") ;
		}
		retval = write (mfd, &c, 1) ;
		if (retval != 1) {
			printf("\nWrite Error, write returned %d,"
			"  errno %d, exiting...\n", retval, errno) ;
			perror ("midi write") ;
		}

	}
}
