/************************************************************************
 * ftap: a Linux-based, MIDI-based program for running tapping and music
 * experiments.
 * 
 * Copyright (C) 1999, 2000 Steven A. Finney
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Steve Finney can be reached by email at finney.17@osu.edu.
 */

/*
 * Although this program is provided "as is", I have taken some pains to
 * try to make it robust and general purpose. I will certainly try to
 * respond to bug reports, bug fixes, suggestions, and comments. Although
 * I don't know of any major bugs, there are certainly some rough spots,
 * and the (verbose) comments in the code (particularly in the headers)
 * are somewhat out of date (but they should be mostly correct). They'll
 * be cleaned up someday. This program has been compiled with gcc.
 */

/***************************************************************************
 * External definitions of all the configurable parameters, as well as some
 * (internally-used) #defines for their values. The actual default
 * initializations (and explanations) are in params.c; this is basically
 * a hacked version of that file to create the necessary extern definitions.
 *
 * The trigger event table (event_table[]) is not defined here.
 * 
 * Modification History:
 * 4/22/98, sf, added REV_VEL and RAND_VEL defines.
 * 10/25/98, sf, added click file parameters (up to 2 external files
 * fully specifying a train of output events), also offsets for each, also
 * diagnostic values for actual misscheduled events.
 * 3/10/00, sf, remove obsolete metron_cnt param and unused midiprog param..
 * 4/9/00, sf, add new metronome array parameters, and change names.
 * 4/11/00, sf, replace SCALEPITCH and MELPITCH with a single FILESEQPITCH,
 * add pitchseq_file param.
 * 8/11/00, sf, add VMODE parameter.
 */


/**************************************************************************
 * Character valued parameters
 */

extern	char sub_param[]	;
extern	char trial_param[]	;
extern	char block_param[]	;
extern	char comment_param[] ;

extern 	char av_delay_param[] ; 	/* diagnostic for output only! */
extern  char sched_av_param[]	;	/* diagnostic for output only! */
extern  char sched_max_param[]	;	/* diagnostic for output only! */
extern  char sched_maxtime_param[] ;	/* diagnostic for output only! */
extern  char sched_gt1_param[]	;	/* diagnostic for output only! */
extern  char sched_gt5_param[]	;	/* diagnostic for output only! */
extern  char sched_gt10_param[]	;	/* diagnostic for output only! */
extern  char in_disc_max_param[];	/* diagnostic for output only! */
extern  char in_disc_max_time_param[] ; /* diagnostic for output only! */
extern  char out_disc_av_param[];	/* diagnostic for output only! */
extern  char out_disc_max_param[];	/* diagnostic for output only! */
extern  char out_disc_max_time_param[] ;/* diagnostic for output only! */

extern	char click1_file_param[] ;
extern	char click2_file_param[] ;

extern 	char pitchseq_file_param[] ;

/**************************************************************************
 * Integer valued parameters (including on/off flags). There are two
 * feedback channels (although only one will be normally necessary),
 * and each of the channels can be independently defined.
 */

extern	int feed1_on_param ;
extern	int feed1_chan_param ;
extern	int feed1_note_param ;
extern	int feed1_vel_param ;
extern	int feed1_len_param ;
extern	int feed1_pmode_param ;
extern	int feed1_dmode_param ;
extern	int feed1_dval_param ;
extern	int feed1_vmode_param ;

extern	int feed2_on_param ;
extern	int feed2_chan_param ;
extern	int feed2_note_param ;
extern	int feed2_vel_param ;
extern	int feed2_len_param ;
extern	int feed2_pmode_param ;
extern	int feed2_dmode_param ;
extern	int feed2_dval_param ;
extern	int feed2_vmode_param ;

extern	int split_point_param ;

extern 	int pitchlag_param ;

extern	int mask_on_param ;
extern	int mask_chan_param ;
extern	int mask_note_param ;
extern	int mask_vel_param ;

extern	int met_chan_param ;
extern	int met_note_param ;
extern	int met_vel_param ;
extern	int met_len_param ;

extern	int metron_on_param ;
extern	int mspb_param ;

extern	int stdout_param ;


extern  int click1_offset_param ;
extern  int click2_offset_param ;

extern  int full_param_print_param ;

#ifdef PPT

extern	int delayppt_param ;
extern	int delayppt_n_param ;
extern	int delayppt_uplim_param ;
extern	int delayppt_lowlim_param ;

#endif 

/**********************************************************************
 *  Integer array  parameters 
 */

extern	int met_pattern_array_cnt_param  ;
extern	int met_pattern_array_list_param[]  ;
extern	int met_note_array_cnt_param  ;
extern	int met_note_array_list_param[]  ;
extern	int met_len_array_cnt_param  ;
extern	int met_len_array_list_param[]  ;
extern	int met_chan_array_cnt_param  ;
extern	int met_chan_array_list_param[]  ;
extern	int met_vel_array_cnt_param  ;
extern	int met_vel_array_list_param[]  ;

extern	int randdelay_array_cnt_param  ;
extern	int randdelay_array_list_param[]  ;

/**************************************************************************
 * #define values for some parameters, for internal use. These names are NOT
 * understood by the parameter file parsing mechanism.
 */

/****************
 * Defines for the pitch and delay mapping modes for the two (keystroke)
 * feedback channels. Often, a setting  of 0 means  "use keystroke input 
 * values" (i.e., no mapping change).  
 *
 * Other forms of delay or pitch mapping could be implemented in C code.
 * (see map.c).
 */

/* Pitch mapping modes, for FEEDN_PMODE parameters. 
 * SAMEPITCH means all input notes are mapped to the feedN_note values, 
 * REVPITCH is a reversed keyboard (low notes at top). LARGEPITCH is
 * a large but consistent pitch mapping applying to all octaves. RANDPITCH
 * randomly maps each pitch within the range (up or down) of a musical fourth.
 * All of these mappings should be freely applicable to one or both MIDI
 * channels. 
 *
 * FILESEQPITCH plays fixed sequences of notes, read in from a file, 
 * regardless  of input keystroke. For now, attempting
 * to apply this in a  multiple feedback channel case is "undefined".
 * Note that with
 * some tone generators note cutoffs may occur if the same note ends up
 * being scheduled twice in rapid succession.
 *
 * Wish list: make file-driven octave and full keyboard mappings, instead
 * of having them hard-wired.
 */

#define RIGHTPITCH	0
#define SAMEPITCH	1
#define REVPITCH	2
#define LARGEPITCH	3
#define RANDPITCH	4
#define FILESEQPITCH	5
#define LAGPITCH	7

/* should a user add custom pitch mapping modes, they should start
 * at this value
 */
#define USER_PITCH_START	50


/* Delay mapping modes, for FEEDN_DMODE parameters. 
 * FIXED_DELAY means all notes are delayed by feedN_dval for that channel.
 * RAND_DELAY means randomly choose one of the nrdelays_param values 
 * specified in randdelays[]; this _cannot_ currently be specified per
 * channel. UNIFORM_DELAY is a uniform distribution over an internally
 * hardwired range (currently 100-300).
 */

#define SYNC_DELAY	0
#define FIXED_DELAY	1
#define RAND_DELAY	2
#define UNIFORM_DELAY	3

/* should a user add custom delay mapping modes, they should start
 * at this value
 */

#define USER_DELAY_START	50

#ifdef PPT

#define PPT_DELAY	50

#endif





/* Mapping modes for velocity (new VMODE parameter). 
 */

#define KEY_VEL		0
#define FIXED_VEL	1
#define REV_VEL		2
#define RAND_VEL	3

/* should a user add custom velocity mapping modes, they should start
 * at this value
 */
#define USER_VEL_START	50


/* defines for feedN_on parameter: 0 means no sound, 1 means feedback for
 * all notes, 2  allows feedback only >= the split point, and 3 allows
 * feedback only  < split_point,
 * respectively.
 */

#define FEED_OFF	0
#define FEED_ALL	1
#define FEED_ABOVE	2
#define FEED_BELOW	3


/* Define for number of feedback channels, and for internal ID's for each
 * channel. The FCHAN values  are used as indices into the fchan_params array,
 * so they must be 0 and 1. I can't imagine a need for more feedback 
 * channels, so these shouldn't change.
 */

#define NFCHANS		2
#define FCHAN1 		0
#define FCHAN2		1

/* NOTE: NCHAN_PARAMS will need to change if any more per-feedback-channel
 * parameters are added !!!!
 */
#define NCHAN_PARAMS	9

/* subscripts for values for particular parameters. These crucially must
 * match the actual initialization of fchan_params.
 */
#define FCHAN_ON_INDEX		0
#define FCHAN_CHAN_INDEX	1
#define FCHAN_NOTE_INDEX	2
#define FCHAN_VEL_INDEX		3
#define FCHAN_LEN_INDEX		4
#define FCHAN_PMODE_INDEX	5
#define FCHAN_DMODE_INDEX	6
#define FCHAN_DVAL_INDEX	7
#define FCHAN_VMODE_INDEX	8

/* a 2 dimensional array of pointers to the per-channel integer parameters, 
 * so we can always access the parameter values through this structure, even
 * if the actual values change on the fly.
 */

extern int * fchan_params [NFCHANS] [NCHAN_PARAMS] ;
